/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sam.timingAnalyzer;

import com.quantumdata.sam.Formats.FindClosestFormat;
import com.quantumdata.sam.Formats.FormatType;
import com.quantumdata.sam.Formats.VideoIDCode;
import com.quantumdata.sam.MainGui;
import com.quantumdata.sam.SignalAnalysisModule;
import com.quantumdata.sam.reporting.TimingAnalysisReport.Result;
import com.quantumdata.sam.reporting.TimingAnalysisReport.TestResults;
import com.quantumdata.sam.tableUtils.AttributiveCellTableModel;
import com.quantumdata.sam.tableUtils.ICellAttribute;
import com.quantumdata.sam.tableUtils.ICellBorder;
import com.quantumdata.sam.tableUtils.ICellColor;
import com.quantumdata.sam.tableUtils.ICellSpan;
import com.quantumdata.sam.timingAnalyzer.TimingAnalyzerEngine;
import com.quantumdata.sam.timingAnalyzer.TimingAnalyzerMeasuredDataTable;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.border.MatteBorder;

public class TimingAnalyzerMeasuredDataTableModel
extends AttributiveCellTableModel {
    private static final long serialVersionUID = 1L;
    public static final int DVIC_COLUMN_NUMBER = 1;
    public static final int NAME_COLUMN_NUMBER = 2;
    public static final int HTOT_COLUMN_NUMBER = 3;
    public static final int HRES_COLUMN_NUMBER = 4;
    public static final int HSPD_COLUMN_NUMBER = 5;
    public static final int HSPW_COLUMN_NUMBER = 6;
    public static final int HSPP_COLUMN_NUMBER = 7;
    public static final int HVPD_COLUMN_NUMBER = 8;
    public static final int VTOT_COLUMN_NUMBER = 9;
    public static final int VRES_COLUMN_NUMBER = 10;
    public static final int VSPD_COLUMN_NUMBER = 11;
    public static final int VSPW_COLUMN_NUMBER = 12;
    public static final int VSPP_COLUMN_NUMBER = 13;
    public static final int SCAN_COLUMN_NUMBER = 14;
    public static final int FRAT_COLUMN_NUMBER = 15;
    public static final int RESULT_COLUMN_NUMBER = 16;
    public static final int VIDEO_CODE_COLUMN_NUMBER = 1;
    public static final int FORMAT_COLUMN_NUMBER = 2;
    public static final int PIXEL_CLOCK_COLUMN_NUMBER = 3;
    public static final int H_TOTAL_COLUMN_NUMBER = 4;
    public static final int H_ACTIVE_COLUMN_NUMBER = 5;
    public static final int VIDEO_TO_HS_COLUMN_NUMBER = 6;
    public static final int HS_POLARITY_COLUMN_NUMBER = 7;
    public static final int HS_LEN_COLUMN_NUMBER = 8;
    public static final int V_TOTAL_COLUMN_NUMBER = 9;
    public static final int V_ACTIVE_COLUMN_NUMBER = 10;
    public static final int VS_TO_VIDEO_COLUMN_NUMBER = 11;
    public static final int VS_LEN_COLUMN_NUMBER = 12;
    public static final int VS_POLARITY_COLUMN_NUMBER = 13;
    public static final int HV_OFFSET_COLUMN_NUMBER = 14;
    public static final int HDMI_RESULT_COLUMN_NUMBER = 15;
    private TestResults tr = new TestResults();
    TimingAnalyzerMeasuredDataTable table;

    public TimingAnalyzerMeasuredDataTableModel(Vector vector, int n, TimingAnalyzerMeasuredDataTable timingAnalyzerMeasuredDataTable) {
        super(vector, n);
        this.table = timingAnalyzerMeasuredDataTable;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void insertRow(int n) {
        this.insertRow(n, (Vector)null);
        this.insertRow(n, (Vector)null);
        if (this.measureData(n)) {
            ICellAttribute iCellAttribute = ((AttributiveCellTableModel)this.table.getModel()).getCellAttribute();
            iCellAttribute.insertRow();
            iCellAttribute.insertRow();
        } else {
            this.removeRow(n);
            this.removeRow(n);
            MainGui.getStatus().setForeground(Color.RED);
            MainGui.getStatus().setText("Closest Matching Format Not Found!");
        }
        for (int i = 0; i < this.tr.getResult().size(); ++i) {
            this.tr.getResult().get(i).setTestnumber(new Integer(i + 1).toString());
        }
        this.formatData();
    }

    public void replaceRow(int n) {
        this.deleteRow(n);
        this.insertRow(n);
    }

    public void deleteRow(int n) {
        this.removeRow(n);
        this.removeRow(n);
        this.tr.getResult().remove(n / 2);
        for (int i = 0; i < this.tr.getResult().size(); ++i) {
            this.tr.getResult().get(i).setTestnumber(new Integer(i + 1).toString());
        }
        ICellAttribute iCellAttribute = ((AttributiveCellTableModel)this.table.getModel()).getCellAttribute();
        iCellAttribute.deleteRow();
        iCellAttribute.deleteRow();
        this.formatData();
    }

    public Object getValueAt(int n, int n2) {
        Result result = this.tr.getResult().get(n / 2);
        if (this.table.isHdmiCTSDisplayFilterMode()) {
            switch (n2) {
                case 0: {
                    return result.getTestnumber();
                }
                case 1: {
                    return VideoIDCode.getDvicString(Integer.parseInt(result.getDvic()));
                }
                case 2: {
                    if (!result.getDvic().equalsIgnoreCase("0")) {
                        return "<HTML><font size=2>" + VideoIDCode.getVideoIDCodeString(Integer.parseInt(result.getDvic())) + "</HTML>";
                    }
                    return result.getClosestFormat();
                }
                case 3: {
                    return new DecimalFormat("##.000").format(Double.parseDouble(n % 2 == 0 ? result.getPrat() : result.getFormatPrat()) / 1000000.0);
                }
                case 4: {
                    return n % 2 == 0 ? result.getHtot() : result.getFormatHtot();
                }
                case 5: {
                    return n % 2 == 0 ? result.getHres() : result.getFormatHres();
                }
                case 6: {
                    return n % 2 == 0 ? result.getHspd() : result.getFormatHspd();
                }
                case 7: {
                    return n % 2 == 0 ? (result.getHspp().equals("1") ? "+" : "-") : (result.getFormatHspp().equals("1") ? "+" : "-");
                }
                case 8: {
                    return n % 2 == 0 ? result.getHspw() : result.getFormatHspw();
                }
                case 9: {
                    double d = n % 2 == 0 ? Double.parseDouble(result.getVtot()) / Double.parseDouble(result.getScan()) : Double.parseDouble(result.getFormatVtot()) / Double.parseDouble(result.getFormatScan());
                    return new Integer(new Double(d).intValue()).toString();
                }
                case 10: {
                    double d = n % 2 == 0 ? Double.parseDouble(result.getVres()) / Double.parseDouble(result.getScan()) : Double.parseDouble(result.getFormatVres()) / Double.parseDouble(result.getFormatScan());
                    return new Integer(new Double(d).intValue()).toString();
                }
                case 11: {
                    int n3;
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    if (n % 2 == 0) {
                        d4 = Double.parseDouble(result.getVtot());
                        d3 = Double.parseDouble(result.getScan());
                        d2 = Double.parseDouble(result.getVres());
                        d = Double.parseDouble(result.getVspd());
                        n3 = Integer.parseInt(result.getVtot());
                    } else {
                        d4 = Double.parseDouble(result.getFormatVtot());
                        d3 = Double.parseDouble(result.getFormatScan());
                        d2 = Double.parseDouble(result.getFormatVres());
                        d = Double.parseDouble(result.getFormatVspd());
                        n3 = Integer.parseInt(result.getFormatVtot());
                    }
                    double d5 = n3 % 2 == 0 ? d4 / d3 - d2 / d3 - d : (d4 - d3 + 1.0) / d3 - d2 / d3 - d;
                    return new Integer(new Double(d5).intValue()).toString();
                }
                case 12: {
                    return n % 2 == 0 ? result.getVspw() : result.getFormatVspw();
                }
                case 13: {
                    return n % 2 == 0 ? (result.getVspp().equals("1") ? "+" : "-") : (result.getFormatVspp().equals("1") ? "+" : "-");
                }
                case 14: {
                    return n % 2 == 0 ? result.getHvpd() : result.getFormatHvpd();
                }
                case 15: {
                    return result.getTestStatus();
                }
            }
        } else {
            switch (n2) {
                case 0: {
                    return result.getTestnumber();
                }
                case 1: {
                    return VideoIDCode.getDvicString(Integer.parseInt(result.getDvic()));
                }
                case 2: {
                    return result.getClosestFormat();
                }
                case 3: {
                    return n % 2 == 0 ? result.getHtot() : result.getFormatHtot();
                }
                case 4: {
                    return n % 2 == 0 ? result.getHres() : result.getFormatHres();
                }
                case 5: {
                    return n % 2 == 0 ? result.getHspd() : result.getFormatHspd();
                }
                case 6: {
                    return n % 2 == 0 ? result.getHspw() : result.getFormatHspw();
                }
                case 8: {
                    return n % 2 == 0 ? result.getHvpd() : result.getFormatHvpd();
                }
                case 7: {
                    return n % 2 == 0 ? result.getHspp() : result.getFormatHspp();
                }
                case 9: {
                    return n % 2 == 0 ? result.getVtot() : result.getFormatVtot();
                }
                case 10: {
                    return n % 2 == 0 ? result.getVres() : result.getFormatVres();
                }
                case 11: {
                    return n % 2 == 0 ? result.getVspd() : result.getFormatVspd();
                }
                case 12: {
                    return n % 2 == 0 ? result.getVspw() : result.getFormatVspw();
                }
                case 13: {
                    return n % 2 == 0 ? result.getVspp() : result.getFormatVspp();
                }
                case 14: {
                    return n % 2 == 0 ? result.getScan() : result.getFormatScan();
                }
                case 15: {
                    double d = n % 2 == 0 ? Double.parseDouble(result.getHrat()) / Double.parseDouble(result.getVtot()) : Double.parseDouble(result.getFormatHrat()) / Double.parseDouble(result.getFormatVtot());
                    return new DecimalFormat("##.000").format(d);
                }
                case 16: {
                    return result.getTestStatus();
                }
            }
        }
        return null;
    }

    public boolean measureData(int n) {
        Result result = TimingAnalyzerEngine.retrieveMeasurementsFromInstrument();
        if (result != null) {
            FormatType formatType = new FormatType();
            formatType.setScan(Integer.parseInt(result.getScan()));
            formatType.setHres(Integer.parseInt(result.getHres()));
            formatType.setVres(Integer.parseInt(result.getVres()));
            formatType.setVtot(Integer.parseInt(result.getVtot()));
            formatType.setHtot(Integer.parseInt(result.getHtot()));
            formatType.setHrat(Integer.parseInt(result.getHrat()));
            formatType.setHspw(Integer.parseInt(result.getHspw()));
            formatType.setVspw(Integer.parseInt(result.getVspw()));
            formatType.setHspd(Integer.parseInt(result.getHspd()));
            formatType.setVspd(Integer.parseInt(result.getVspd()));
            formatType.setHspp(Integer.parseInt(result.getHspp()));
            formatType.setVspp(Integer.parseInt(result.getVspp()));
            FormatType formatType2 = FindClosestFormat.findClosestFormat(SignalAnalysisModule.formats, formatType);
            if (formatType2 != null) {
                double d;
                result.setFormatScan(new Integer(formatType2.getScan()).toString());
                result.setFormatHres(new Integer(formatType2.getHres()).toString());
                result.setFormatVres(new Integer(formatType2.getVres()).toString());
                result.setFormatVtot(new Integer(formatType2.getVtot()).toString());
                result.setFormatHtot(new Integer(formatType2.getHtot()).toString());
                result.setFormatHrat(new Double(formatType2.getHrat()).toString());
                result.setFormatHspw(new Integer(formatType2.getHspw()).toString());
                result.setFormatVspw(new Integer(formatType2.getVspw()).toString());
                result.setFormatHspd(new Integer(formatType2.getHspd()).toString());
                result.setFormatVspd(new Integer(formatType2.getVspd()).toString());
                result.setFormatHspp(new Integer(formatType2.getHspp()).toString());
                result.setFormatVspp(new Integer(formatType2.getVspp()).toString());
                result.setFormatHvpd(new Integer(formatType2.getHvpd()).toString());
                result.setFormatFrat(new Float(formatType2.getFrat()).toString());
                result.setClosestFormat(formatType2.getName());
                result.setDvic(Integer.toString(formatType2.getDvic()));
                result.setHdmiSpecFormatName(formatType2.getDvic() != 0 ? VideoIDCode.getVideoIDCodeString(formatType2.getDvic()) : formatType2.getName());
                result.setFormatPrat(new DecimalFormat("##.000").format(formatType2.getPrat()));
                if (result.getHtot().equals(result.getFormatHtot()) && result.getHres().equals(result.getFormatHres()) && result.getHspd().equals(result.getFormatHspd()) && result.getHspw().equals(result.getFormatHspw()) && result.getHspp().equals(result.getFormatHspp()) && result.getHvpd().equals(result.getFormatHvpd()) && result.getVtot().equals(result.getFormatVtot()) && result.getVres().equals(result.getFormatVres()) && result.getVspd().equals(result.getFormatVspd()) && result.getVspw().equals(result.getFormatVspw()) && result.getVspp().equals(result.getFormatVspp()) && result.getScan().equals(result.getFormatScan()) && result.getHrat().equals(result.getFormatHrat())) {
                    result.setPerfectMatch("1");
                } else {
                    result.setPerfectMatch("0");
                }
                if (result.getHtot().equals(result.getFormatHtot()) && result.getHres().equals(result.getFormatHres()) && result.getHspd().equals(result.getFormatHspd()) && result.getHspw().equals(result.getFormatHspw()) && result.getHspp().equals(result.getFormatHspp()) && result.getHvpd().equals(result.getFormatHvpd()) && result.getVtot().equals(result.getFormatVtot()) && result.getVres().equals(result.getFormatVres()) && result.getVspd().equals(result.getFormatVspd()) && result.getVspw().equals(result.getFormatVspw()) && result.getVspp().equals(result.getFormatVspp()) && result.getScan().equals(result.getFormatScan())) {
                    double d2;
                    d = Double.parseDouble(result.getHrat());
                    if (d >= (d2 = Double.parseDouble(result.getFormatHrat())) * 0.994 && d <= d2 * 1.005) {
                        result.setTestStatus("PASS");
                    } else {
                        result.setTestStatus("FAIL");
                    }
                } else {
                    result.setTestStatus("FAIL");
                }
                result.setTestnumber(new Integer(n / 2 + 1).toString());
                d = Double.parseDouble(result.getHrat()) / Double.parseDouble(result.getVtot());
                result.setFrat(new DecimalFormat("##.000").format(d));
                d = Double.parseDouble(result.getFormatHrat()) / Double.parseDouble(result.getFormatVtot());
                result.setFormatFrat(new DecimalFormat("##.000").format(d));
                this.tr.getResult().add(n / 2, result);
                return true;
            }
            return false;
        }
        return false;
    }

    public void formatData() {
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black);
        ICellColor iCellColor = (ICellColor)((Object)this.getCellAttribute());
        ICellSpan iCellSpan = (ICellSpan)((Object)this.getCellAttribute());
        ICellBorder iCellBorder = (ICellBorder)((Object)this.getCellAttribute());
        for (int i = 0; i < this.getRowCount(); ++i) {
            int n;
            if (i % 2 == 0) {
                for (n = 0; n < this.getColumnCount(); ++n) {
                    if (((String)this.getValueAt(i, n)).equals((String)this.getValueAt(i + 1, n))) {
                        iCellSpan.combine(i, i + 1, n);
                        iCellBorder.setBorder(matteBorder, i, n);
                        continue;
                    }
                    if (this.table.isHdmiCTSDisplayFilterMode() && n == 3) {
                        iCellColor.setBackground(new Color(253, 184, 35), i, n);
                        iCellColor.setBackground(new Color(253, 184, 35), i + 1, n);
                        continue;
                    }
                    if (n == 15 && !this.table.isHdmiCTSDisplayFilterMode()) {
                        iCellColor.setBackground(new Color(253, 184, 35), i, n);
                        iCellColor.setBackground(new Color(253, 184, 35), i + 1, n);
                        continue;
                    }
                    iCellColor.setBackground(Color.RED, i, n);
                    iCellColor.setBackground(Color.RED, i + 1, n);
                }
            } else {
                for (n = 0; n < this.getColumnCount(); ++n) {
                    iCellBorder.setBorder(matteBorder, i, n);
                }
            }
            if (this.tr.getResult().get(i / 2).getTestStatus().equals("PASS")) {
                iCellColor.setBackground(Color.GREEN, i, this.getColumnCount() - 1);
                continue;
            }
            iCellColor.setBackground(Color.RED, i, this.getColumnCount() - 1);
        }
    }

    public TestResults getTr() {
        return this.tr;
    }
}

